<?php
/**
 * Log Factory
 *
 * Tworzy i zwraca obiekt rejestrujący dane w pliku, bazie danych mysql lub bazie sqlite
 */
class Log_Factory {
  /**
   * Tworzy dziennik
   *
   * @param string $type Sposób przechowywania danych dziennika: plik, mysql lub sqlite
   * @param array $options Opcje klasy dziennika
   */
  public function getLog($type = 'file', array $options)
  {
    // Zamiana liter na małe
    $type = strtolower($type);
    
    // Sprawdzenie nazwy klasy i dołączenie jej
    $class = "Log_" .ucfirst($type);
    require_once str_replace('_', DIRECTORY_SEPARATOR, $class).'.php';
        // Utworzenie obiektu klasy i ustawienie opcji
    $log = new $class($options);
    switch ($type) {
      case 'file':
        $log->setPath($options['location']);
        break;
      case 'mysql':
        $log->setUser($options['username']);
        $log->setPassword($options['password']);
        $log->setDBName($options['location']);
        break;
      case 'sqlite':
        $log->setDBPath($options['location']);
        break;
    }
    
    return $log;
  }
}
?>